package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.ServiceProvider;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface ServiceProvidersDao extends SchemaAwareDao {
    CompletableFuture<Boolean> insert(ServiceProvider serviceProvider);

    CompletableFuture<Optional<ServiceProvider>> read(String id);

    CompletableFuture<Optional<ServiceProvider>> update(ServiceProvider serviceProvider);

    CompletableFuture<Boolean> delete(String id);

    CompletableFuture<TokenBasePage<ServiceProvider>> list(String filterById, int pageSize, String pageToken);

    CompletableFuture<Boolean> exists(String id);

    CompletableFuture<List<ServiceProvider>> findAll();
}
