package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.UserSettings;

/**
 * @author Oleg Baryshnikov
 */
public interface UserSettingsDao extends SchemaAwareDao {

    CompletableFuture<List<UserSettings>> findAll();

    CompletableFuture<UserSettings> findByLogin(String login);

    CompletableFuture<UserSettings> upsert(UserSettings settings);

    CompletableFuture<Boolean> deleteUser(String login);
}
