package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.core.db.model.ViewHistory;


/**
 * @author snoop
 */
public interface ViewHistoryDao extends SchemaAwareDao {

    CompletableFuture<Optional<ViewHistory>> upsert(ViewHistory viewHistory);

    CompletableFuture<List<ViewHistory>> findAll();

    CompletableFuture<List<ViewHistory>> findHistoryByLogin(String login);

    CompletableFuture<Boolean> deleteById(String login, String id);
}
