package ru.yandex.solomon.core.db.dao.client;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.db.model.ProjectPermission;
import ru.yandex.solomon.flags.FeatureFlag;
import ru.yandex.solomon.flags.FeatureFlagsHolder;
import ru.yandex.solomon.ydb.page.PageOptions;
import ru.yandex.solomon.ydb.page.PagedResult;
import ru.yandex.solomon.ydb.page.TokenBasePage;
import ru.yandex.solomon.ydb.page.TokenPageOptions;

/**
 * @author Alexey Trushkin
 */
public class YdbOrClientProjectsDao implements ProjectsDao {

    private static final String PREFIX = "METHODS_WITHOUT_PROJECT_PREFIX_";
    private final FeatureFlagsHolder ffHolder;
    private final ProjectsDao ydbDelegateDao;
    private final GrpcProjectManagerLegacyClient grpcProjectManagerLegacyClient;

    public YdbOrClientProjectsDao(
            FeatureFlagsHolder featureFlagsHolder,
            ProjectsDao ydbDelegateDao,
            Optional<GrpcProjectManagerLegacyClient> projectManagerClient)
    {
        this.ffHolder = featureFlagsHolder;
        this.ydbDelegateDao = ydbDelegateDao;
        this.grpcProjectManagerLegacyClient = projectManagerClient.orElse(null);
    }

    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return ydbDelegateDao.createSchemaForTests();
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return ydbDelegateDao.dropSchemaForTests();
    }

    @Override
    public CompletableFuture<Boolean> insert(Project project) {
        return getDao(project.getId()).insert(project);
    }

    @Override
    public CompletableFuture<Optional<Project>> findById(String id) {
        return getDao(id).findById(id);
    }

    @Override
    public CompletableFuture<List<Project>> findAllNames() {
        return getDao(PREFIX + "findAllNames").findAllNames();
    }

    @Override
    public CompletableFuture<PagedResult<Project>> find(String text, String abcFilter, String login, @Nullable EnumSet<ProjectPermission> filterByPermissions, PageOptions pageOpts) {
        return getDao(PREFIX + "find").find(text, abcFilter, login, filterByPermissions, pageOpts);
    }

    @Override
    public CompletableFuture<PagedResult<Project>> findInProjects(String text, String abcFilter, Set<String> projectIds, PageOptions pageOpts) {
        return getDao(PREFIX + "findInProjects").findInProjects(text, abcFilter, projectIds, pageOpts);
    }

    @Override
    public CompletableFuture<TokenBasePage<Project>> findV3(String text, int pageSize, String pageToken) {
        return getDao(PREFIX + "findV3").findV3(text, pageSize, pageToken);
    }

    @Override
    public CompletableFuture<Optional<Project>> partialUpdate(Project project, boolean canChangeOwner, boolean canChangeInternalOptions, boolean canUpdateOldFields) {
        return getDao(project.getId()).partialUpdate(project, canChangeOwner, canChangeInternalOptions, canUpdateOldFields);
    }

    @Override
    public CompletableFuture<Void> upsertProjects(List<Project> projects) {
        return getDao(PREFIX + "upsertProjects").upsertProjects(projects);
    }

    @Override
    public CompletableFuture<Boolean> deleteOne(String id, boolean skipValidation) {
        return getDao(id).deleteOne(id, skipValidation);
    }

    @Override
    public CompletableFuture<Boolean> exists(String id) {
        return getDao(id).exists(id);
    }

    @Override
    public CompletableFuture<TokenBasePage<Project>> list(TokenPageOptions opts) {
        return getDao(PREFIX + "findAllNames").list(opts);
    }

    private ProjectsDao getDao(String flagProject) {
        if (grpcProjectManagerLegacyClient == null) {
            return ydbDelegateDao;
        }
        if (ffHolder.hasFlag(FeatureFlag.READ_PROJECT_FROM_PM, flagProject)) {
            return grpcProjectManagerLegacyClient;
        }
        return ydbDelegateDao;
    }
}
