package ru.yandex.solomon.core.db.dao.kikimr;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import org.apache.commons.lang3.text.StrSubstitutor;


/**
 * @author snoop
 */
public class QueryTemplate {

    private final String entityName;
    private final Map<String, String> queryTextById;
    private final Class clazz;

    public QueryTemplate(String entityName, List<String> queryIds) {
        this(QueryTemplate.class, entityName, queryIds);
    }

    public QueryTemplate(Class clazz, String entityName, List<String> queryIds) {
        this.clazz = clazz;
        this.entityName = entityName;
        this.queryTextById = queryIds
            .stream()
            .collect(Collectors.toMap(Function.identity(), this::loadQuery));
    }

    public QueryText build(Map<String, ?> parameters) {
        return new QueryText(queryTextById
            .entrySet()
            .stream()
            .collect(Collectors.toMap(Map.Entry::getKey, e -> StrSubstitutor.replace(e.getValue(), parameters))));
    }

    private static String getInsertPlaceholderValue() {
        return "INSERT";
    }

    private String loadQuery(String queryId) {
        try {
            String resourceName = entityName + "_" + queryId + ".yql";
            return Resources.toString(Objects.requireNonNull(clazz.getResource(resourceName), resourceName), Charsets.UTF_8);
        } catch (Exception e) {
            throw new RuntimeException("cannot load query '" + queryId + '\'', e);
        }
    }
}
