package ru.yandex.solomon.core.db.dao.memory;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.Nullable;

import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.db.model.ProjectPermission;
import ru.yandex.solomon.ydb.page.PageOptions;
import ru.yandex.solomon.ydb.page.PagedResult;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Vladimir Gordiychuk
 */
public class InMemoryProjectsDao implements ProjectsDao {
    private final ConcurrentMap<String, Project> projectById = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<Boolean> insert(Project project) {
        return CompletableFuture.supplyAsync(() -> projectById.putIfAbsent(project.getId(), project) == null);
    }

    @Override
    public CompletableFuture<Optional<Project>> findById(String id) {
        return CompletableFuture.supplyAsync(() -> Optional.ofNullable(projectById.get(id)));
    }

    @Override
    public CompletableFuture<List<Project>> findAllNames() {
        return CompletableFuture.supplyAsync(() -> new ArrayList<>(projectById.values()));
    }

    @Override
    public CompletableFuture<PagedResult<Project>> find(
        String text,
        String abcFilter,
        String login,
        @Nullable EnumSet<ProjectPermission> filterByPermissions,
        PageOptions pageOptions)
    {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public CompletableFuture<PagedResult<Project>> findInProjects(String text, String abcFilter, Set<String> projectIds, PageOptions pageOpts) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public CompletableFuture<TokenBasePage<Project>> findV3(String text, int pageSize, String pageToken) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public CompletableFuture<Optional<Project>> partialUpdate(
        Project project,
        boolean canChangeOwner,
        boolean canChangeInternalOptions,
        boolean canUpdateOldFields)
    {
        return CompletableFuture.supplyAsync(() -> {
            projectById.replace(project.getId(), project);
            return Optional.ofNullable(project);
        });
    }

    @Override
    public CompletableFuture<Void> upsertProjects(List<Project> projects) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public CompletableFuture<Boolean> deleteOne(String id, boolean skipValidation) {
        return CompletableFuture.supplyAsync(() -> projectById.remove(id) != null);
    }

    @Override
    public CompletableFuture<Boolean> exists(String id) {
        return CompletableFuture.supplyAsync(() -> projectById.containsKey(id));
    }

    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return CompletableFuture.runAsync(() -> {});
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return CompletableFuture.supplyAsync(() -> {
            projectById.clear();
            return null;
        });
    }
}
