package ru.yandex.solomon.core.db.dao.memory;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.core.db.dao.ServicesDao;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.ShardSettings;
import ru.yandex.solomon.ydb.page.PageOptions;
import ru.yandex.solomon.ydb.page.PagedResult;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
public class InMemoryServicesDao implements ServicesDao {

    @Override
    public CompletableFuture<Boolean> insert(Service service) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Optional<Service>> findOne(String projectId, String folderId, String serviceId) {
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<PagedResult<Service>> findByProjectId(String projectId, String folderId, PageOptions pageOpts, String text, ShardSettings.Type monitoringModel) {
        return CompletableFuture.completedFuture(PagedResult.empty());
    }

    @Override
    public CompletableFuture<TokenBasePage<Service>> findByProjectIdPaged(String projectId, String folderId, int pageSize, String pageToken, String text) {
        return CompletableFuture.completedFuture(TokenBasePage.empty());
    }

    @Override
    public CompletableFuture<List<Service>> findAll() {
        return CompletableFuture.completedFuture(List.of());
    }

    @Override
    public CompletableFuture<PagedResult<Service>> findAll(PageOptions pageOpts, String text) {
        return CompletableFuture.completedFuture(PagedResult.empty());
    }

    @Override
    public CompletableFuture<Optional<Service>> partialUpdate(Service service) {
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public CompletableFuture<Boolean> deleteOne(String projectId, String folderId, String serviceId) {
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public CompletableFuture<Void> deleteByProjectId(String projectId, String folderId) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Boolean> exists(String projectId, String folderId, String serviceId) {
        return CompletableFuture.completedFuture(false);
    }


    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return CompletableFuture.runAsync(() -> {
        });
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return CompletableFuture.runAsync(() -> {
        });
    }
}
