package ru.yandex.solomon.core.db.dao.memory;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.dao.ServiceProvidersDao;
import ru.yandex.solomon.core.db.model.ServiceProvider;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
@ParametersAreNonnullByDefault
public class InMemoryYdbServiceProvidersDao implements ServiceProvidersDao {

    private final ConcurrentMap<String, ServiceProvider> byId = new ConcurrentHashMap<>();

    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return notImplemented();
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return notImplemented();
    }

    @Override
    public CompletableFuture<Boolean> insert(ServiceProvider serviceProvider) {
        return CompletableFuture.supplyAsync(() -> byId.putIfAbsent(serviceProvider.getId(), serviceProvider) == null);
    }

    @Override
    public CompletableFuture<Optional<ServiceProvider>> read(String id) {
        return CompletableFuture.supplyAsync(() -> Optional.ofNullable(byId.get(id)));
    }

    @Override
    public CompletableFuture<Optional<ServiceProvider>> update(ServiceProvider serviceProvider) {
        return notImplemented();
    }

    @Override
    public CompletableFuture<Boolean> delete(String id) {
        return CompletableFuture.supplyAsync(() -> byId.remove(id) != null);
    }

    @Override
    public CompletableFuture<TokenBasePage<ServiceProvider>> list(String filterById, int pageSize, String pageToken) {
        return notImplemented();
    }

    @Override
    public CompletableFuture<Boolean> exists(String id) {
        return notImplemented();
    }

    @Override
    public CompletableFuture<List<ServiceProvider>> findAll() {
        return notImplemented();
    }

    private <T> CompletableFuture<T> notImplemented() {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("not implemented"));
    }
}
