package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class ClusterCloudDnsConf extends DefaultObject {
    private static final Interner<ClusterCloudDnsConf> INTERNER = Interners.newWeakInterner();
    private final CloudEnv env;
    private final String name;
    private final String[] labels;

    private ClusterCloudDnsConf(
            CloudEnv env,
            String name,
            String[] labels)
    {
        this.env = env;
        this.name = StringInterner.intern(Nullables.orEmpty(name));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
    }

    @JsonCreator
    public static ClusterCloudDnsConf of(
            @JsonProperty("env") CloudEnv env,
            @JsonProperty("name") String name,
            @JsonProperty("labels") String[] labels)
    {
        return INTERNER.intern(new ClusterCloudDnsConf(env, name, labels));
    }

    @JsonProperty
    public CloudEnv getEnv() {
        return env;
    }

    @JsonProperty
    public String getName() {
        return name;
    }

    @JsonProperty
    public String[] getLabels() {
        return labels;
    }
}
