package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class ClusterConductorGroupConf extends DefaultObject {

    private static final Interner<ClusterConductorGroupConf> INTERNER = Interners.newWeakInterner();

    private final String group;
    private final String[] labels;

    private ClusterConductorGroupConf(String group, String[] labels) {
        this.group = StringInterner.intern(Nullables.orEmpty(group));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
    }

    @JsonCreator
    public static ClusterConductorGroupConf of(@JsonProperty("group") String group,@JsonProperty("labels") String[] labels) {
        return INTERNER.intern(new ClusterConductorGroupConf(group, labels));
    }

    @JsonProperty
    public String getGroup() {
        return group;
    }

    @JsonProperty
    public String[] getLabels() {
        return labels;
    }
}
