package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class ClusterConductorTagConf extends DefaultObject {

    private static final Interner<ClusterConductorTagConf> INTERNER = Interners.newWeakInterner();

    private final String name;
    private final String[] labels;

    private ClusterConductorTagConf(String name, String[] labels) {
        this.name = StringInterner.intern(Nullables.orEmpty(name));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
    }

    @JsonCreator
    public static ClusterConductorTagConf of(@JsonProperty("name") String name, @JsonProperty("labels") String[] labels) {
        return INTERNER.intern(new ClusterConductorTagConf(name, labels));
    }

    @JsonProperty
    public String getName() {
        return name;
    }

    @JsonProperty
    public String[] getLabels() {
        return labels;
    }
}
