package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;


/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class ClusterHostListConf extends DefaultObject {

    private static final Interner<ClusterHostListConf> INTERNER = Interners.newWeakInterner();

    private final String urlPattern;
    private final String ranges;
    private final String dc;
    private final String[] labels;

    private ClusterHostListConf(
            String urlPattern,
            String ranges,
            String dc,
            String[] labels)
    {
        this.urlPattern = StringInterner.intern(Nullables.orEmpty(urlPattern));
        this.ranges = StringInterner.intern(Nullables.orEmpty(ranges));
        this.dc = StringInterner.intern(Nullables.orEmpty(dc));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
    }

    @JsonCreator
    public static ClusterHostListConf of(
        @JsonProperty("urlPattern") String urlPattern,
        @JsonProperty("ranges") String ranges,
        @JsonProperty("dc") String dc,
        @JsonProperty("labels") String[] labels)
    {
        return INTERNER.intern(new ClusterHostListConf(urlPattern, ranges, dc, labels));
    }

    /**
     * Don't mind `url` in field name, it is actually 'hostPattern'
     * May contain printf-like pattern like `%d` or `%03d` that is filled with ranges
     */
    @JsonProperty
    public String getUrlPattern() {
        return urlPattern;
    }

    /**
     * Ranges like '0-10 20-40'.
     * Used to fill 'urlPattern'.
     */
    @JsonProperty
    public String getRanges() {
        return ranges;
    }

    /**
     * DC name (deprecated field, DC is autodetected)
     */
    @JsonProperty
    public String getDc() {
        return dc;
    }

    /**
     * Optional label list
     */
    @JsonProperty
    public String[] getLabels() {
        return labels;
    }
}
