package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Sergey Polovko
 */
@ParametersAreNonnullByDefault
public class ClusterHostUrlConf extends DefaultObject {

    private static final Interner<ClusterHostUrlConf> INTERNER = Interners.newWeakInterner();

    private final String url;
    private final String[] labels;
    private final boolean ignorePorts;

    private ClusterHostUrlConf(
            String url,
            String[] labels,
            Boolean ignorePorts)
    {
        this.url = StringInterner.intern(Nullables.orEmpty(url));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
        this.ignorePorts = Nullables.orFalse(ignorePorts);
    }

    @JsonCreator
    public static ClusterHostUrlConf of(
        @JsonProperty("url") String url,
        @JsonProperty("labels") String[] labels,
        @JsonProperty("ignorePorts") Boolean ignorePorts)
    {
        return INTERNER.intern(new ClusterHostUrlConf(url, labels, ignorePorts));
    }

    /**
     * Url of text file with host list
     */
    @JsonProperty
    public String getUrl() {
        return url;
    }

    /**
     * Optional label list
     */
    @JsonProperty
    public String[] getLabels() {
        return labels;
    }

    @JsonProperty
    public boolean isIgnorePorts() {
        return ignorePorts;
    }
}
