package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author msherbakov
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClusterInstanceGroupConf extends DefaultObject {

    private static final Interner<ClusterInstanceGroupConf> INTERNER = Interners.newWeakInterner();

    private final String instanceGroupId;
    private final String folderId;
    private final String[] labels;

    private ClusterInstanceGroupConf(
            @Nullable String instanceGroupId,
            @Nullable String folderId,
            @Nullable String[] labels)
    {
        this.instanceGroupId = StringInterner.intern(Nullables.orEmpty(instanceGroupId));
        this.folderId = StringInterner.intern(Nullables.orEmpty(folderId));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
    }

    @JsonCreator
    public static ClusterInstanceGroupConf of(
        @JsonProperty("instanceGroupId") @Nullable String instanceGroupId,
        @JsonProperty("folderId") @Nullable String folderId,
        @JsonProperty("labels") @Nullable String[] labels)
    {
        return INTERNER.intern(new ClusterInstanceGroupConf(instanceGroupId, folderId, labels));
    }

    @JsonProperty
    public String getInstanceGroupId() {
        return instanceGroupId;
    }

    @JsonProperty
    public String getFolderId() { return folderId; }

    @JsonProperty
    public String[] getLabels() {
        return labels;
    }
}
