package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author alexlovkov
 */
 @ParametersAreNonnullByDefault
public class ClusterNetworkConf extends DefaultObject {

    private static final Interner<ClusterNetworkConf> INTERNER = Interners.newWeakInterner();

    private final String network;
    private final Integer port;
    private final String[] labels;

    private ClusterNetworkConf(
            @Nullable String network,
            Integer port,
            @Nullable String[] labels)
    {
        this.network = StringInterner.intern(Nullables.orEmpty(network));
        this.port = port;
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
    }

    @JsonCreator
    public static ClusterNetworkConf of(
        @JsonProperty("network") @Nullable String network,
        @JsonProperty("port") Integer port,
        @JsonProperty("labels") @Nullable String[] labels)
    {
        return INTERNER.intern(new ClusterNetworkConf(network, port, labels));
    }

    @JsonProperty
    public String getNetwork() {
        return network;
    }

    @JsonProperty
    public Integer getPort() {
        return port;
    }

    @JsonProperty
    public String[] getLabels() {
        return labels;
    }
}
