package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ClusterServiceAssociation extends DefaultObject {

    private final String id;
    private final String name;
    private final String shardId;
    private final int shardVersion;
    private final ShardState shardState;

    private ClusterServiceAssociation(
        String id,
        String name,
        String shardId,
        int shardVersion,
        ShardState shardState)
    {
        this.id = id;
        this.name = name;
        this.shardId = shardId;
        this.shardVersion = shardVersion;
        this.shardState = shardState;
    }

    public static ClusterServiceAssociation createAssociationToCluster(Shard shard) {
        return new ClusterServiceAssociation(
          shard.getClusterId(),
          shard.getClusterName(),
          shard.getId(),
          shard.getVersion(),
          shard.getState()
        );
    }

    public static ClusterServiceAssociation createAssociationToService(Shard shard) {
        return new ClusterServiceAssociation(
            shard.getServiceId(),
            shard.getServiceName(),
            shard.getId(),
            shard.getVersion(),
            shard.getState()
        );
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getShardId() {
        return shardId;
    }

    public int getShardVersion() {
        return shardVersion;
    }

    public ShardState getShardState() {
        return shardState;
    }
}
