package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author alexlovkov
 */
@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown = true)
public class ClusterYpConf extends DefaultObject {

    private static final Interner<ClusterYpConf> INTERNER = Interners.newWeakInterner();

    private final String podSetId;
    private final String endpointSetId;
    private final String cluster;
    private final String[] labels;
    private final String tvmLabel;
    private final String ypLabel;

    private ClusterYpConf(
            @Nullable String podSetId,
            @Nullable String endpointSetId,
            @Nullable String cluster,
            @Nullable String[] labels,
            @Nullable String tvmLabel,
            @Nullable String ypLabel)
    {
        this.podSetId = StringInterner.intern(Nullables.orEmpty(podSetId));
        this.endpointSetId = StringInterner.intern(Nullables.orEmpty(endpointSetId));
        this.cluster = StringInterner.intern(Nullables.orEmpty(cluster));
        this.labels = StringInterner.internArray(Nullables.orEmpty(labels));
        this.tvmLabel = StringInterner.intern(Nullables.orEmpty(tvmLabel));
        this.ypLabel = StringInterner.intern(Nullables.orEmpty(ypLabel));
    }

    @JsonCreator
    public static ClusterYpConf of(
        @JsonProperty("podSetId") @Nullable String podSetId,
        @JsonProperty("endpointSetId") @Nullable String endpointSetId,
        @JsonProperty("cluster") @Nullable String cluster,
        @JsonProperty("labels") @Nullable String[] labels,
        @JsonProperty("tvmLabel") @Nullable String tvmLabel,
        @JsonProperty("ypLabel") @Nullable String ypLabel)
    {
        return INTERNER.intern(new ClusterYpConf(podSetId, endpointSetId, cluster, labels, tvmLabel, ypLabel));
    }

    @JsonProperty
    public String getPodSetId() {
        return podSetId;
    }

    @JsonProperty
    public String getEndpointSetId() {
        return endpointSetId;
    }

    @JsonProperty
    public String getCluster() {
        return cluster;
    }

    @JsonProperty
    public String[] getLabels() {
        return labels;
    }

    @JsonProperty
    public String getTvmLabel() { return tvmLabel; }

    @JsonProperty
    public String getYpLabel() { return ypLabel; }
}
