package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DashboardPanel extends DefaultObject {

    private final Type type;
    private final String title;
    private final String subtitle;
    private final String url;
    private final String markdown;
    private final int rowspan;
    private final int colspan;

    @JsonCreator
    public DashboardPanel(
        @JsonProperty("type") @Nullable Type type,
        @JsonProperty("title") @Nullable String title,
        @JsonProperty("subtitle") @Nullable String subtitle,
        @JsonProperty("url") @Nullable String url,
        @JsonProperty("markdown") @Nullable String markdown,
        @JsonProperty("rowspan") @Nullable Integer rowspan,
        @JsonProperty("colspan") @Nullable Integer colspan)
    {
        this.type = Nullables.orDefault(type, Type.IFRAME);
        this.title = Nullables.orEmpty(title);
        this.subtitle = Nullables.orEmpty(subtitle);
        this.url = Nullables.orEmpty(url);
        this.markdown = Nullables.orEmpty(markdown);
        this.rowspan = Nullables.orZero(rowspan);
        this.colspan = Nullables.orZero(colspan);
    }

    @JsonProperty
    public Type getType() {
        return type;
    }

    @JsonProperty
    public String getTitle() {
        return title;
    }

    @JsonProperty
    public String getSubtitle() {
        return subtitle;
    }

    @JsonProperty
    public String getUrl() {
        return url;
    }

    @JsonProperty
    public String getMarkdown() {
        return markdown;
    }

    @JsonProperty
    public int getRowspan() {
        return rowspan;
    }

    @JsonProperty
    public int getColspan() {
        return colspan;
    }

    public enum Type {
        IFRAME,
        MARKDOWN,
    }
}
