package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class DashboardRow extends DefaultObject {

    private final DashboardPanel[] panels;

    @JsonCreator
    public DashboardRow(
        @JsonProperty("panels") @Nullable DashboardPanel[] panels) {
        this.panels = Nullables.orDefault(panels, new DashboardPanel[0]);
    }

    @JsonProperty
    public DashboardPanel[] getPanels() {
        return panels;
    }
}
