package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.stockpile.api.EDecimPolicy;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum DecimPolicy {
    UNDEFINED(EDecimPolicy.UNDEFINED),

    POLICY_KEEP_FOREVER(EDecimPolicy.POLICY_KEEP_FOREVER),
    POLICY_5_MIN_AFTER_7_DAYS(EDecimPolicy.POLICY_5_MIN_AFTER_7_DAYS),
    POLICY_1_MIN_AFTER_1_MONTH_5_MIN_AFTER_3_MONTHS(EDecimPolicy.POLICY_1_MIN_AFTER_1_MONTH_5_MIN_AFTER_3_MONTHS),
    POLICY_1_MIN_AFTER_1_MONTH_5_MIN_AFTER_2_MONTHS(EDecimPolicy.POLICY_1_MIN_AFTER_1_MONTH_5_MIN_AFTER_2_MONTHS),
    POLICY_5_MIN_AFTER_2_MONTHS(EDecimPolicy.POLICY_5_MIN_AFTER_2_MONTHS),
    POLICY_5_MIN_AFTER_8_DAYS(EDecimPolicy.POLICY_5_MIN_AFTER_8_DAYS),

    ;

    public static final DecimPolicy DEFAULT = POLICY_5_MIN_AFTER_7_DAYS;
    public static final DecimPolicy YASM_DEFAULT = POLICY_5_MIN_AFTER_8_DAYS;

    private final EDecimPolicy id;

    DecimPolicy(EDecimPolicy id) {
        this.id = id;
    }

    public EDecimPolicy toProto() {
        return id;
    }

    public static DecimPolicy parse(@Nullable String valueStr) {
        if (valueStr == null) {
            return UNDEFINED;
        }
        for (DecimPolicy value : values()) {
            if (value.name().equals(valueStr)) {
                return value;
            }
        }
        return UNDEFINED;
    }

    public static DecimPolicy fromProto(EDecimPolicy proto) {
        for (DecimPolicy value : values()) {
            if (value.id.getNumber() == proto.getNumber()) {
                return value;
            }
        }
        return UNDEFINED;
    }

    public boolean isDefined() {
        return this != UNDEFINED;
    }
}
