package ru.yandex.solomon.core.db.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.collection.Nullables;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public final class FolderMenu extends AbstractAuditable {
    private final String id;
    private final String projectId;
    private final MenuItem[] items;

    private FolderMenu(Builder builder) {
        super(builder);
        this.id = Objects.requireNonNull(builder.id, "folder id must not be null");
        this.projectId = Objects.requireNonNull(builder.projectId, "project id must not be null");
        this.items = Nullables.orDefault(builder.items, new MenuItem[0]);
    }

    public static FolderMenu empty(String projectId) {
        return newBuilder().setId(projectId).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getId() {
        return id;
    }

    public String getProjectId() {
        return projectId;
    }

    public MenuItem[] getItems() {
        return items;
    }

    public static final class Builder extends AuditableBuilder<Builder> {
        private String projectId;
        private String id;
        private MenuItem[] items = new MenuItem[0];

        private Builder() {
        }

        private Builder(FolderMenu folderMenu) {
            super(folderMenu);
            this.id = folderMenu.getId();
            this.projectId = folderMenu.getProjectId();
            this.items = folderMenu.getItems();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setItems(MenuItem[] items) {
            this.items = items;
            return this;
        }

        public FolderMenu build() {
            return new FolderMenu(this);
        }
    }
}
