package ru.yandex.solomon.core.db.model;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MenuItem extends DefaultObject {

    private final String title;
    private final String url;
    private final MenuItem[] children;
    private final String selectors;

    @JsonCreator
    public MenuItem(
        @Nullable @JsonProperty("title") String title,
        @Nullable @JsonProperty("url") String url,
        @Nullable @JsonProperty("children") MenuItem[] children,
        @Nullable @JsonProperty("selectors") String selectors)
    {
        this.title = Objects.requireNonNull(title, "menu item title must not be null");
        this.url = Nullables.orEmpty(url);
        this.children = Nullables.orDefault(children, new MenuItem[0]);
        this.selectors = Nullables.orEmpty(selectors);
    }

    @JsonProperty
    public String getTitle() {
        return title;
    }

    @JsonProperty
    public String getUrl() {
        return url;
    }

    @JsonProperty
    public MenuItem[] getChildren() {
        return children;
    }

    @JsonProperty
    public String getSelectors() {
        return selectors;
    }
}
