package ru.yandex.solomon.core.db.model;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProjectSettings extends DefaultObject {
    private final String id;
    private final Map<String, String> settings;

    public ProjectSettings(String id, Map<String, String> settings) {
        this.id = id;
        this.settings = Nullables.orEmpty(settings);
    }

    public String getId() {
        return id;
    }

    public Map<String, String> getSettings() {
        return settings;
    }
}
