package ru.yandex.solomon.core.db.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Vladimir Gordiychuk
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class ReferenceConf extends DefaultObject {
    @JsonProperty("label")
    public final String label;
    @JsonProperty("services")
    public final List<String> services;
    @JsonProperty("types")
    public final List<String> types;
    @JsonProperty("crossFolder")
    public final boolean crossFolder;

    @JsonCreator
    public ReferenceConf(
            @JsonProperty("label") String label,
            @JsonProperty("services") List<String> services,
            @JsonProperty("types") List<String> types,
            @JsonProperty("crossFolder") boolean crossFolder)
    {
        this.label = label;
        this.services = services;
        this.types = types;
        this.crossFolder = crossFolder;
    }
}
