package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class Selector extends DefaultObject {

    private final String name;
    private final String value;

    @JsonCreator
    public Selector(
        @JsonProperty("name") String name,
        @JsonProperty("value") String value) {
        this.name = name;
        this.value = value;
    }

    @JsonProperty
    public String getName() {
        return name;
    }

    @JsonProperty
    public String getValue() {
        return value;
    }
}
