package ru.yandex.solomon.core.db.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@ParametersAreNonnullByDefault
public class ServiceProviderShardSettings extends DefaultObject {
    public static final ServiceProviderShardSettings EMPTY =
            new ServiceProviderShardSettings(ServiceMetricConf.empty(), 0, 0, 0);

    private final ServiceMetricConf metricConf;
    private final int metricsTtlDays;
    private final int grid;
    private final int interval;

    @JsonCreator
    public ServiceProviderShardSettings(
        @JsonProperty("metricConf") @Nullable ServiceMetricConf metricConf,
        @JsonProperty("metricsTtlDays") int metricsTtlDays,
        @JsonProperty("grid") int grid,
        @JsonProperty("interval") int interval
    )
    {
        this.metricConf = Nullables.orDefault(metricConf, ServiceMetricConf.empty());
        this.metricsTtlDays = metricsTtlDays;
        this.grid = grid;
        this.interval = interval;
    }

    @JsonProperty("metricConf")
    public ServiceMetricConf getMetricConf() {
        return metricConf;
    }

    @JsonProperty("metricsTtlDays")
    public int getMetricsTtlDays() {
        return metricsTtlDays;
    }

    @JsonProperty("grid")
    public int getGrid() {
        return grid;
    }

    @JsonProperty("interval")
    public int getInterval() {
        return interval;
    }
}
