package ru.yandex.solomon.core.db.model;

public record ShardPartitionId(int shardId, int partId, long genId) {
    private static final int DEFAULT_PARTITION_ID = 0;
    private static final long DEFAULT_GEN_ID = 1;

    public ShardPartitionId {
        if (genId <= 0) {
            throw new IllegalArgumentException(String.format("ShardPartitionId{%d/%d} genId must be greater than 0 (actual %d)", shardId, partId, genId));
        }
    }

    public static ShardPartitionId of(int shardId, int partId, long genId) {
        return new ShardPartitionId(shardId, partId, genId);
    }

    public static ShardPartitionId onePartitionShard(int shardId) {
        return new ShardPartitionId(shardId, DEFAULT_PARTITION_ID, DEFAULT_GEN_ID);
    }
}
