package ru.yandex.solomon.core.db.model;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum ShardState {
    INACTIVE("INACTIVE"),
    READ_ONLY("READ_ONLY"),
    WRITE_ONLY("WRITE_ONLY"),
    RW("RW"),
    // for test-migrate purpose and backward compatibility only, remove after migration
    ACTIVE("ACTIVE");

    public static final ShardState DEFAULT = RW;
    public static final String DEFAULT_NAME = "RW";
    private final String name;

    ShardState(String name) {
        this.name = name;
    }

    public static ShardState mapFromOldFormat(ShardState oldState) {
        if (oldState == ShardState.ACTIVE) {
            return ShardState.RW;
        } else {
            return ShardState.INACTIVE;
        }
    }

    public static boolean isNewItemState(String state) {
        for (ShardState current : values()) {
            if (current.name.equals(state)) {
                return true;
            }
        }
        return false;
    }

    public static ShardState mapFromString(String state) {
        for (ShardState current : values()) {
            if (current.name.equals(state)) {
                return current;
            }
        }
        throw new IllegalArgumentException("can't find enum for state:" + state);
    }

    public String getName() {
        return name;
    }

    /**
     * if we take RW (new format) then we return ACTIVE (old format)
     * if some user use old format ACTIVE, then we return new format (RW) so we could find in db (backward compatibility)
     * fakeValue otherwise
     */
    public String getAnotherName() {
        if (this == RW) {
            return ShardState.ACTIVE.name();
        } else if (this == ACTIVE) {
            return ShardState.RW.getName();
        } else {
            // sql require parameter, so we return which will never be found
            return "fakeValue";
        }
    }
}
