package ru.yandex.solomon.core.db.model;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ShortGraphOrDashboardConf {

    private final String id;
    private final String projectId;
    private final String name;
    private final Selector[] selectors;

    public ShortGraphOrDashboardConf(
        String id,
        String projectId,
        String name,
        Selector[] selectors)
    {
        this.id = id;
        this.projectId = projectId;
        this.name = name;
        this.selectors = selectors;
    }

    public String getId() {
        return id;
    }

    public String getProjectId() {
        return projectId;
    }

    public String getName() {
        return name;
    }

    public Selector[] getParameters() {
        return selectors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShortGraphOrDashboardConf)) {
            return false;
        }

        ShortGraphOrDashboardConf that = (ShortGraphOrDashboardConf) o;

        if (!id.equals(that.id)) {
            return false;
        }
        if (!projectId.equals(that.projectId)) {
            return false;
        }
        if (!name.equals(that.name)) {
            return false;
        }
        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return Arrays.equals(selectors, that.selectors);
    }

    @Override
    public int hashCode() {
        int result = id.hashCode();
        result = 31 * result + projectId.hashCode();
        result = 31 * result + name.hashCode();
        result = 31 * result + Arrays.hashCode(selectors);
        return result;
    }

    @Override
    public String toString() {
        return "ShortGraphOrDashboard{" +
            "id='" + id + '\'' +
            ", projectId='" + projectId + '\'' +
            ", name='" + name + '\'' +
            ", selectors=" + Arrays.toString(selectors) +
            '}';
    }
}

