package ru.yandex.solomon.core.db.model;

import java.util.Set;
import java.util.stream.Collectors;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

/**
 * @author Vladimir Gordiychuk
 */
public final class StringInterner {
    private static final Interner<String> I = Interners.newWeakInterner();

    private StringInterner() {
    }

    public static String[] internArray(String[] array) {
        if (array == null || array.length == 0) {
            return array;
        }
        for (int i = 0; i < array.length; i++) {
            array[i] = intern(array[i]);
        }
        return array;
    }

    public static Set<String> internSet(Set<String> set) {
        return set.stream().map(StringInterner::intern).collect(Collectors.toUnmodifiableSet());
    }

    public static String intern(String value) {
        return value == null ? null : I.intern(value);
    }
}
