package ru.yandex.solomon.core.db.model;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class UserSettings extends DefaultObject {

    private final String login;
    private final Map<String, String> settings;

    public UserSettings(String login, Map<String, String> settings) {
        this.login = login;
        this.settings = Nullables.orEmpty(settings);
    }

    public String getLogin() {
        return login;
    }

    public Map<String, String> getSettings() {
        return settings;
    }
}
