package ru.yandex.solomon.core.db.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.labels.validate.StrictValidator;

/**
 * @author alexlovkov
 */
@JsonFormat(shape = JsonFormat.Shape.STRING)
public enum ValidationMode {

    /**
     * default value, use old rules for validation.
     */
    @JsonProperty("legacySkip")
    LEGACY_SKIP("legacySkip"),

    /**
     * use {@link StrictValidator}, skip metrics with forbidden labels.
     */
    @JsonProperty("strictSkip")
    STRICT_SKIP("strictSkip"),

    /**
     * use {@link StrictValidator}, fail query if any metric contains forbidden label.
     */
    @JsonProperty("strictFail")
    STRICT_FAIL("strictFail");

    private final String name;

    ValidationMode(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @JsonCreator
    public static ValidationMode fromString(String validationMode) {
        if (validationMode == null || validationMode.isEmpty()) {
            return ValidationMode.LEGACY_SKIP;
        }
        for (ValidationMode current : ValidationMode.values()) {
            if (current.name.equals(validationMode)) {
                return current;
            }
        }
        throw new IllegalArgumentException("validationMode is not valid:" + validationMode);
    }
}
