package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum AggregationType implements StringEnum {
    AVG("avg"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    LAST("last"),
    ;

    private final String value;

    AggregationType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<AggregationType> r = StringEnumResolver.r(AggregationType.class);
}
