package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum ColorSchemeType implements StringEnum {
    AUTO(""),
    DEFAULT("default"),
    GRADIENT("gradient"),
    ;

    private final String value;

    ColorSchemeType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<ColorSchemeType> r = StringEnumResolver.r(ColorSchemeType.class);
}
