package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum DownsamplingAggregationType implements StringEnum {
    DEFAULT("default"),
    AVG("avg"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    LAST("last"),
    ;

    public static final DownsamplingAggregationType DEFAULT_VALUE = DEFAULT;

    private final String value;

    DownsamplingAggregationType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<DownsamplingAggregationType> r =
        StringEnumResolver.r(DownsamplingAggregationType.class);
}
