package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum DownsamplingFillType implements StringEnum {
    NULL("null"),
    NONE("none"),
    PREVIOUS("previous"),
    ;

    public static final DownsamplingFillType DEFAULT_VALUE = NULL;

    private final String value;

    DownsamplingFillType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<DownsamplingFillType> r =
        StringEnumResolver.r(DownsamplingFillType.class);
}
