package ru.yandex.solomon.core.db.model.graph;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
public enum DownsamplingMode implements StringEnum {
    AUTO("auto"),
    DEFAULT("auto"),
    BY_INTERVAL("byInterval"),
    BY_POINTS("byPoints"),
    OFF("off"),
    ;

    private final String value;

    DownsamplingMode(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<DownsamplingMode> r = StringEnumResolver.r(DownsamplingMode.class);
}
