package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum FilterFunction implements StringEnum {
    AVG("avg"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    LAST("last"),
    STD("std"),
    COUNT("count"),
    INTEGRATE("integrate"),
    RANDOM("random"),
    ;

    private final String value;

    FilterFunction(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<FilterFunction> r = StringEnumResolver.r(FilterFunction.class);
}
