package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum FilterOrder implements StringEnum {
    NONE("none"),
    TOP("top"),
    BOTTOM("bottom"),
    ;

    private final String value;

    FilterOrder(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<FilterOrder> r = StringEnumResolver.r(FilterOrder.class);
}
