package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.solomon.core.db.model.Selector;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class GraphElement extends DefaultObject {

    private final String title;
    private final GraphElementType type;
    private final Selector[] selectors;
    private final String expression;
    private final String link;
    private final Boolean area;
    private final String stack;
    private final Boolean down;
    private final String color;
    private final YaxisPosition yaxis;
    private final ElementTransform transform;

    @JsonCreator
    public GraphElement(
        @JsonProperty("title") String title,
        @JsonProperty("type") GraphElementType type,
        @JsonProperty("selectors") @Nullable Selector[] selectors,
        @JsonProperty("expression") @Nullable String expression,
        @JsonProperty("link") @Nullable String link,
        @JsonProperty("area") @Nullable Boolean area,
        @JsonProperty("stack") @Nullable String stack,
        @JsonProperty("down") @Nullable Boolean down,
        @JsonProperty("color") @Nullable String color,
        @JsonProperty("yaxis") @Nullable YaxisPosition yaxis,
        @JsonProperty("transform") @Nullable ElementTransform transform)
    {
        this.title = Nullables.orEmpty(title);
        this.type = Nullables.orDefault(type, GraphElementType.SELECTORS);
        this.selectors = Nullables.orDefault(selectors, new Selector[0]);
        this.expression = Nullables.orEmpty(expression);
        this.link = Nullables.orEmpty(link);
        this.area = area;
        this.stack = Nullables.orEmpty(stack);
        this.down = down;
        this.color = Nullables.orEmpty(color);
        this.yaxis = Nullables.orDefault(yaxis, YaxisPosition.LEFT);
        this.transform = Nullables.orDefault(transform, ElementTransform.NONE);
    }

    @JsonProperty
    public String getTitle() {
        return title;
    }

    @JsonProperty
    public GraphElementType getType() {
        return type;
    }

    @JsonProperty
    public Selector[] getSelectors() {
        return selectors;
    }

    @JsonProperty
    public String getExpression() {
        return expression;
    }

    @JsonProperty
    public String getStack() {
        return stack;
    }

    @JsonProperty
    @Nullable
    public Boolean getDown() {
        return down;
    }

    @JsonProperty
    public String getColor() {
        return color;
    }

    @JsonProperty
    public YaxisPosition getYaxis() {
        return yaxis;
    }

    @JsonProperty
    public ElementTransform getTransform() {
        return transform;
    }

    @JsonProperty
    @Nullable
    public Boolean getArea() {
        return area;
    }

    @JsonProperty
    public String getLink() {
        return link;
    }
}
