package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum GraphMode implements StringEnum {
    GRAPH("graph"),
    PIE("pieChart"),
    BARS("bars"),
    DISTRIBUTION("distribution"),
    HEATMAP("heatmap"),
    NONE("none"),
    ;

    private final String value;

    GraphMode(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<GraphMode> r = StringEnumResolver.r(GraphMode.class);
}
