package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum GraphTransform implements StringEnum {
    NONE("none"),
    DIFFERENTIATE("differentiate"),
    DIFFERENTIATE_WITH_NEGATIVE("differentiate_with_negative"),
    INTEGRATE("integrate"),
    MOVING_AVERAGE("moving_average"),
    MOVING_PERCENTILE("moving_percentile"),
    DIFF("diff"),
    ASAP("asap"),
    ;

    private final String value;

    GraphTransform(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<GraphTransform> r = StringEnumResolver.r(GraphTransform.class);
}
