package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum InterpolationType implements StringEnum {
    LINEAR("linear"),
    LEFT("left"),
    RIGHT("right"),
    NONE("none"),
    ;

    private final String value;

    InterpolationType(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<InterpolationType> r = StringEnumResolver.r(InterpolationType.class);
}
