package ru.yandex.solomon.core.db.model.graph;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public enum OverLinesTransform implements StringEnum {
    NONE("none"),
    PERCENTILE("PERCENTILE"),
    WEIGHTED_PERCENTILE("WEIGHTED_PERCENTILE"),
    SUMMARY("SUMMARY"),
    ;

    private final String value;

    OverLinesTransform(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<OverLinesTransform> r = StringEnumResolver.r(OverLinesTransform.class);
}
