package ru.yandex.solomon.core.db.model.graph;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;


/**
 * @author Oleg Baryshnikov
 */
public enum SecondaryGraphMode implements StringEnum {
    PIE("pieChart"),
    BARS("bars"),
    DISTRIBUTION("distribution"),
    HEATMAP("heatmap"),
    NONE("none"),
    ;

    private final String value;

    SecondaryGraphMode(String value) {
        this.value = value;
    }

    @Override
    public String value() {
        return value;
    }

    public static final StringEnumResolver<SecondaryGraphMode> r = StringEnumResolver.r(SecondaryGraphMode.class);
}
