package ru.yandex.solomon.core.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author Oleg Baryshnikov
 */
@ResponseStatus(HttpStatus.CONFLICT)
@ParametersAreNonnullByDefault
public class ConflictException extends RuntimeException {

    public ConflictException(String message) {
        super(message);
    }

    public static ConflictException alreadyExists(String entityName, String projectId, String entityId) {
        String message =
                String.format("%s with id %s already exists in Solomon, maybe not in project %s", entityName, entityId, projectId);
        return new ConflictException(message);
    }

    public static ConflictException alreadyExists(String entityName, String entityId) {
        String message =
                String.format("%s with id %s already exists in Solomon", entityName, entityId);
        return new ConflictException(message);
    }
}
