package ru.yandex.solomon.core.exceptions;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
@ResponseStatus(HttpStatus.FORBIDDEN)
public class NotOwnerException extends AuthorizationException {

    private final String owner;

    public NotOwnerException(String message, String owner) {
        super(message);
        this.owner = owner;
    }

    public String getOwner() {
        return owner;
    }
}
