package ru.yandex.solomon.core.grpc;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.grpc.utils.GrpcServerFactory;
import ru.yandex.grpc.utils.server.ServerMetrics;
import ru.yandex.grpc.utils.server.interceptors.ClientFilterServerInterceptor;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;

/**
 * @author Vladimir Gordiychuk
 */
@Configuration
public class GrpcContext {

    @Bean
    public ServerMetrics grpcServerMetrics() {
        return new ServerMetrics();
    }

    @Bean
    public ClientFilterServerInterceptor grpcClientFilter() {
        return new ClientFilterServerInterceptor();
    }

    @Bean
    public GrpcServerFactory grpcServerFactory(ThreadPoolProvider threadpool, ServerMetrics metrics, ClientFilterServerInterceptor filter) {
        return new GrpcServerFactory(threadpool, metrics, filter);
    }
}
