package ru.yandex.solomon.core.label;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author Stepan Koltsov
 */
public class FixedOrderStringSorter {

    private final List<String> order;

    // TODO: use faster hash map
    private final Map<String, Integer> orderToIndex;

    public FixedOrderStringSorter(List<String> uniqueStrings) {
        for (String label : uniqueStrings) {
            if (label.isEmpty()) {
                throw new RuntimeException("empty string");
            }
        }

        this.order = uniqueStrings;

        orderToIndex = new HashMap<>();
        for (int i = 0; i < uniqueStrings.size(); i++) {
            String label = uniqueStrings.get(i);
            orderToIndex.put(label, i + 1);
        }
        if (orderToIndex.size() != uniqueStrings.size()) {
            throw new RuntimeException("values are not unique");
        }
    }

    public List<String> getOrder() {
        return order;
    }

    public Comparator<String> asPartialNameComparator() {
        return (a, b) -> {
            Integer aIndex = orderToIndex.getOrDefault(a, Integer.MAX_VALUE);
            Integer bIndex = orderToIndex.getOrDefault(b, Integer.MAX_VALUE);
            if (aIndex != Integer.MAX_VALUE || bIndex != Integer.MAX_VALUE) {
                return Integer.compare(aIndex, bIndex);
            } else {
                return a.compareTo(b);
            }
        };
    }
}
