package ru.yandex.solomon.core.label;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.ReaderX;

import static java.nio.charset.StandardCharsets.UTF_8;


/**
 * @author Stepan Koltsov
 */
public final class LabelConf {
    private LabelConf() {}

    private static final Comparator<String> partialSorterComparator =
        loadLabelOrderList().asPartialNameComparator();

    public static Comparator<String> getPartialSorterComparator() {
        return partialSorterComparator;
    }

    private static FixedOrderStringSorter loadLabelOrderList() {
        InputStream input = Objects.requireNonNull(
            LabelConf.class.getResourceAsStream("labels-order.txt"),
            "cannot find labels-order.txt");

        try (ReaderX reader = new ReaderX(new InputStreamReader(input, UTF_8))) {
            List<String> labelOrderList = reader.readLines()
                .filterNot(String::isEmpty)
                .map(StringUtils::trim);
            return new FixedOrderStringSorter(labelOrderList);
        } catch (IOException e) {
            throw ExceptionUtils.throwException(e);
        }
    }
}
